#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nyin		= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nein		= mxGetPr(prhs[2]);
    double *yss 		= mxGetPr(prhs[3]);
    double *xss 		= mxGetPr(prhs[4]);
    double *Hs 			= mxGetPr(prhs[5]);
    double *Gs 			= mxGetPr(prhs[6]);
    double *H2s 		= mxGetPr(prhs[7]);
    double *G2s 		= mxGetPr(prhs[8]);
    double *Xlag		= mxGetPr(prhs[9]);
    double *eps			= mxGetPr(prhs[10]);

	/* -- Specific Inputs -- */
	int ny 				= nyin[0];
	int nx 				= nxin[0];
	int ne 				= nein[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(2*nx+2*ny+ne,1,mxREAL);
	double *Xt = mxGetPr(plhs[0]);

	/* State */
	mxArray *statemat[1];
	statemat[0] = mxCreateDoubleMatrix(nx+ne+1,1,mxREAL);
	double *state = mxGetPr(statemat[0]);

	int ii, jj;
	for (ii=0;ii<nx;ii++) {
		state[ii] = Xlag[ii]-xss[ii];
	}
	for (ii=0;ii<ne;ii++) {
		state[nx+ii] = eps[ii];
	}
	state[nx+ne] = 1;



	/* Kron State */
	mxArray *kronstatemat[1];
	kronstatemat[0] = mxCreateDoubleMatrix((nx+ne+1)*(nx+ne+1),1,mxREAL);
	double *kronstate = mxGetPr(kronstatemat[0]);

	for (ii=0;ii<nx+ne+1;ii++) {
    	for (jj=0;jj<nx+ne+1;jj++) {
    		kronstate[ii*(nx+ne+1)+jj] = state[ii]*state[jj];
		}
	}


	/* Assemble Transition Equation */
	for (ii=0;ii<nx;ii++) {
		Xt[ii] = xss[ii];

		for (jj=0;jj<nx+ne+1;jj++) {
			Xt[ii] += Hs[jj*nx+ii]*state[jj];
		}
		for (jj=0;jj<(nx+ne+1)*(nx+ne+1);jj++) {
			Xt[ii] += 0.5*H2s[jj*nx+ii]*kronstate[jj];
		}
	}

	for (ii=0;ii<nx;ii++) {
		Xt[nx+ii] = Xlag[ii];
	}

	for (ii=0;ii<ny;ii++) {
		Xt[2*nx+ii] = yss[ii];

		for (jj=0;jj<nx+ne+1;jj++) {
			Xt[2*nx+ii] += Gs[jj*ny+ii]*state[jj];
		}
		for (jj=0;jj<(nx+ne+1)*(nx+ne+1);jj++) {
			Xt[2*nx+ii] += 0.5*G2s[jj*ny+ii]*kronstate[jj];
		}
	}

	for (ii=0;ii<ny;ii++) {
		Xt[2*nx+ny+ii] = Xlag[2*nx+ii];
	}

	for (ii=0;ii<ne;ii++) {
		Xt[2*nx+2*ny+ii] = eps[ii];
	}

}
